/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.security.user;

import org.apache.sling.api.resource.ResourceResolver;

import javax.jcr.RepositoryException;
import javax.jcr.Session;

/**
 * <code>UserPropertiesService</code>...
 */
public abstract class UserPropertiesService {

    public static final String PREFERENCES_PATH = "preferences";

    /**
     * Constant for the profiles root of a given user.
     */
    public static final String PROFILES_ROOT = "profiles";

    /**
     * Constant for the private profile root of a given user.
     */
    public static final String PRIVATE_PROFILE = PROFILES_ROOT + "/private";

    /**
     * Constant for the default public profile root of a given user.
     */
    public static final String PUBLIC_PROFILE = PROFILES_ROOT + "/public";

    /**
     * Constant array of the available default user profiles in descending ranking order.
     */
    public static final String[] DEFAULT_PROFILES = new String[] {PUBLIC_PROFILE, PRIVATE_PROFILE};

    /**
     * Constant for the profile resource type.
     */
    public static final String PROFILE_RESOURCE_TYPE = "cq/security/components/profile";

    /**
     * Constant for the (previous) private profile of a given user.
     *
     * @deprecated use {@link UserPropertiesService#PRIVATE_PROFILE} instead.
     */
    public static final String PROFILE_PATH = "profile";
    public static final String DEFAULT_NODETYPE = "nt:unstructured";

    /**
     * Create a new instance of <code>UserPropertiesManager</code> for the specified <code>resolver</code>.
     *
     * @param resolver The associated resource resolver.
     *
     * @return a new instance of <code>UserPropertiesManager</code>.
     *
     * @throws javax.jcr.RepositoryException If an error occurs.
     */
    public abstract UserPropertiesManager createUserPropertiesManager(ResourceResolver resolver) throws RepositoryException;

    /**
     * Create a new instance of <code>UserPropertiesManager</code> for the specified <code>session</code> and
     * <code>resolver</code>.
     *
     * @param session  The editing session.
     * @param resolver The associated resource resolver.
     *
     * @return a new instance of <code>UserPropertiesManager</code>.
     *
     * @throws javax.jcr.RepositoryException If an error occurs.
     */
    public abstract UserPropertiesManager createUserPropertiesManager(Session session, ResourceResolver resolver)
            throws RepositoryException;

    /**
     * Retrieve the resource type for the user properties with the specified name. The resource types are part of the
     * service configuration.
     *
     * @param userPropertiesName Relative path to the user properties for which the resource type should be returned.
     *
     * @return resource type for the user properties with the specified name or <code>null</code>.
     */
    public abstract String getResourceType(String userPropertiesName);

    /**
     * Retrieve the node type for the user properties with the given name. Note, that the node types are part of the
     * service configuration.
     *
     * @param userPropertiesName Relative path to the user properties for which the node type type should be returned.
     *
     * @return node type for the user properties with the specified name or {@link #DEFAULT_NODETYPE}.
     */
    public abstract String getNodeType(String userPropertiesName);

    /**
     * Retrieves the path to the authorizable node that is identified by the specified <code>authorizableId</code>.
     *
     * @param authorizableId The ID of the authorizable.
     *
     * @return ?The path of the authorizable or <code>null</code>.
     *
     * @throws javax.jcr.RepositoryException If an error occurs.
     */
    public abstract String getAuthorizablePath(String authorizableId) throws RepositoryException;

    /**
     * Retrieves the authorizableID corresponding to the given absolute path pointing to an user properties node.
     *
     * @param userPropertiesPath Absolute path to user properties node.
     *
     * @return The ID of the corresponding authorizable or <code>null</code>.
     *
     * @throws javax.jcr.RepositoryException If an error occurs.
     */
    public abstract String getAuthorizableId(String userPropertiesPath) throws RepositoryException;
}