/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.granite.socketio;

import java.io.IOException;

import javax.annotation.Nonnull;

import org.apache.sling.commons.json.JSONArray;

import aQute.bnd.annotation.ProviderType;

/**
 * Socket.io event emitter.
 *
 * Examples:
 *
 * <xmp>
 * namespace.emit(); // all sockets in namespace
 * namespace.to(r1).emit(); // all sockets in room 'r1'
 * namepsace.broadcast().emit(); // same as above
 *
 * socket.emit(); // only to self
 * socket.broadcast().emit(); // to all sockets excluding self
 * socket.broadcast().to(r1).emit(); // to all sockets in room 'r1', excluding self
 * socket.to(r1).emit(); // to all sockets in room 'r1', including self
 * </xmp>
 */
@ProviderType
public interface SocketIOEmitter {

    /**
     * Emits an event to the socket identified by the string name. Any other parameters can be included.
     *
     * @param eventName name of the event
     * @param arguments optional arguments
     */
    @Nonnull
    SocketIOEmitter emit(@Nonnull String eventName, @Nonnull  Object ... arguments) throws IOException;

    /**
     * Emits an event to the socket identified by the string name. Any other parameters can be included.
     *
     * @param eventName name of the event
     * @param arguments optional arguments
     */
    @Nonnull
    SocketIOEmitter emit(@Nonnull String eventName, @Nonnull JSONArray arguments) throws IOException;

    /**
     * Sets a modifier for a subsequent event emission that the event will
     * only be broadcast to sockets that have joined the given room.
     *
     * To emit to multiple rooms, you can call to several times.
     *
     * @param room name of the room
     * @return a new emitter that will broadcast the events
     */
    @Nonnull
    SocketIOEmitter to(@Nonnull String... room);


}