/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.granite.socketio;

import java.util.Map;

import javax.annotation.Nonnull;

import aQute.bnd.annotation.ProviderType;

/**
 * The socket.io service is the entry point to interact with socket.io and is registered as OSGi service.
 */
@ProviderType
public interface SocketIOService {

    /**
     * Returns a map of all used namespaces.
     * @return namespaces map.
     */
    @Nonnull
    Map<String, SocketIONamespace> getNamespaces();

    /**
     * Registers a socket.io listener.
     * @param listener listener to register
     */
    void register(@Nonnull SocketIOListener listener);

    /**
     * Unregisters a socket.io listener
     * @param listener listener to unregister.
     */
    void unregister(@Nonnull SocketIOListener listener);

}