/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.taskmanagement;

/**
 * Used to specify conditions in a {@link Filter} for a TaskManagement query
 */
public class Condition implements Cloneable {

    /**
     * Used to define the task property name of the condition
     */
    private String propertyName;

    /**
     * Used to define the ComparisonOperator of the condition
     */
    private ComparisonOperator comparisonOperator;

    /**
     * Used to define the comparison value of the condition
     */
    private Object comparisonValue;

    /**
     * a built-in task property
     */
    private TaskProperty taskProperty;

    /**
     * Construct a new Condition instance with null property,
     * comparisonOperator and comparisonValue fields.
     */
    public Condition() {

    }

    /**
     * Get the name of the task property for this condition.
     *
     * @return the task property name.
     */
    public String getPropertyName() {
        if (taskProperty != null) {
            return taskProperty.getPropertyName();
        } else {
            return this.propertyName;
        }
    }

    /**
     * Set the name of the task property for this condition.
     * you may either set a taskProperty or a #setTaskProperty not both
     *
     * @param aPropertyName the task property name.
     */
    public void setPropertyName(String aPropertyName) {
        this.propertyName = aPropertyName;
    }

    /**
     * gets the taskProperty set for this condition
     * @return the taskProperty
     */
    public TaskProperty getTaskProperty() {
        return taskProperty;
    }

    /**
     * sets a built-in task property for this condition.
     * you may either set a taskProperty or a #setPropertyName not both
     * @param taskProperty the built in task property for this condition
     */
    public void setTaskProperty(TaskProperty taskProperty) {
        this.taskProperty = taskProperty;
    }

    /**
     * Get the ComparisonOperator object for this condition.
     *
     * @return The ComparisonOperator for this condition or null if no ComparisonOperator
     *         has been set.
     */
    public ComparisonOperator getComparisonOperator() {
        return this.comparisonOperator;
    }

    /**
     * Set the ComparisonOperator object for this condition
     *
     * @param aComparisonOperator The ComparisonOperator object to set
     */
    public void setComparisonOperator(ComparisonOperator aComparisonOperator) {
        this.comparisonOperator = aComparisonOperator;
    }

    /**
     * Get the comparison value Object for this condition.
     *
     * @return The comparison value as an Object for this condition or null if no comparison value
     *         has been set.
     */
    public Object getComparisonValue() {
        return this.comparisonValue;
    }

    /**
     * Set the comparison value Object for this condition
     *
     * @param aComparisonValue The comparison value Object to set
     */
    public void setComparisonValue(Object aComparisonValue) {
        this.comparisonValue = aComparisonValue;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
