/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.timeline;

import org.apache.sling.api.resource.Resource;

import java.util.Map;

/**
 * The <code>TimelineAggregator</code> is an OSGi-service providing creation of {@link Timeline}s for the given
 * resource. The service can be obtained from the OSGi service registry via the interface.
 */
public interface TimelineAggregator {

    /**
     * Create a {@link Timeline} for the given <code>resource</code>.
     *
     * @param resource The {@link Resource} for which to create a {@link Timeline}.
     *
     * @return The {@link Timeline}.
     */
    Timeline createTimeline(Resource resource);

    /**
     * Returns a collection of all known {@link TimelineEventType}s. The types are provided by the {@link
     * TimelineEventProvider}s registered.
     *
     * @return A {@link Map} of {@link TimelineEventType}s and their keys (names) - or an empty map if no providers are
     *         registered.
     */
    Map<String, TimelineEventType> getTypes();
}
