/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.timeline;

/**
 * A <code>TimelineEvent</code> represents an "action" or "event" that occurred on the {@link
 * org.apache.sling.api.resource.Resource} backing the {@link Timeline} that provided this event. Timline events can
 * only be retrieved via a {@link Timeline}. An event has a {@link TimelineEventType}. The types available are defined
 * by the {@link TimelineEventProvider}s registered in the system and may vary.
 * <p/>
 * An event's basic constituents are its type (see {@link #getType()}), the time of the occurrence (see {@link
 * #getTime()}) and the action (see {@link #getAction()}), and more.
 */
public interface TimelineEvent {

    /**
     * The name of the action that is represented by this event, e.g. "Version Created".
     *
     * @return A string representing the action.
     */
    String getAction();

    /**
     * An optional description of the event, e.g. a comment's text as provided by the user.
     *
     * @return A string representing the action, or <code>null</code> if none was provided.
     */
    String getDescription();

    /**
     * An optional reference to the origin of this event, e.g. a path to a version, or to comment. The format of the
     * origin is dependent on the event type.
     *
     * @return A string representing the origin, or <code>null</code> if none was provided.
     */
    String getOrigin();

    /**
     * The date and time in milliseconds this event occurred.
     *
     * @return A {@link Long} representing the date-time this event occurred.
     */
    long getTime();

    /**
     * Returns the {@link TimelineEventType}s of this event.
     *
     * @return The type.
     */
    TimelineEventType getType();

    /**
     * The ID of the user that caused the event.
     *
     * @return A string representing the user ID.
     */
    String getUserID();
}
