/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.translation.api;

import java.util.Map;

//
/**
 * This TranslationConfig interface is used to return the full list of Language Codes and Content Categories which are
 * stored within the system. These lists are used by the Translation API as the only acceptable inputs to their
 * respective parameters.
 */
public interface TranslationConfig {

    /**
     * Returns a Map of the currently allowed language codes. The default location for the language codes is:
     * "/libs/granite/translation/resources/language"
     * @return {@code Map<String, String>} containing the list of allowed language codes and their respective labels
     *         (in English) {@code (<Language Code, Language Label>)}
     * @throws TranslationException the translation exception
     */
    Map<String, String> getLanguages() throws TranslationException;

    /**
     * Returns a Map of the currently allowed content categories The default location for the categories is:
     * "/libs/granite/translation/resources/categories".
     * @return {@code Map<String, String>} containing the list of allowed content categories and their respective
     *         labels (in English) {@code (<Content Category, Category Label>)}
     * @throws TranslationException the translation exception
     */
    Map<String, String> getCategories() throws TranslationException;

    /** Name of the property on language nodes that contains the label. */
    static final String PROPERTY_LANGUAGE_LABEL = "language";

    /** Name of the property on category nodes that contains the label. */
    static final String PROPERTY_CATEGORY_LABEL = "category";

}