/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.translation.api;

//
/** The TranslationMetadata maintains a list of metadata. */
public interface TranslationMetadata {

    /**
     * Checks if Object translation is required. Used to determine if Object metadata should be translated as well.
     * @return true, if Object translation is required
     */
    boolean isObjectTranslationRequired();

    /**
     * Checks if metadata translation is required.
     * @return true, if metadata translation is required
     */
    boolean isMetadataTranslationRequired();

    /**
     * Checks if supporting Object translation is required. Used to determine if supporting Objects should be
     * translated.
     * @return true, if Supporting Object translation is required
     */
    boolean isSupportingObjectTranslationRequired();

    /**
     * Gets the percentage complete.
     * @return the percentage complete
     */
    int getPercentageComplete();

    /**
     * Gets the translation state.
     * @return the translation state
     */
    TranslationState getTranslationState();

    /**
     * Gets the rough scope. Rough scope is calculated without calling connector API.
     * @return the rough scope
     */
    TranslationScope getInitialScope();

    /**
     * Gets the final scope. Final scope is calculated by calling connector API.
     * @return the final scope
     */
    TranslationScope getFinalScope();
}
