/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.translation.api;

import java.util.Map;

/** The TranslationScope provides scope, word count, size, for a TranslationObject or collection of TranslationObjects */
public interface TranslationScope {

    /**
     * Gets a word count of the total number of words to be translated.
     * @return the number of words
     */
    int getWordCount();

    /**
     * Gets the number of images.
     * @return the number of images
     */
    int getImageCount();

    /**
     * Gets the number of videos.
     * @return the number of videos
     */
    int getVideoCount();

    /**
     * Gets the final scope.<br>
     * There are no mandatory entries in the map and it can contain any custom key.
     * The translation platform does not take any action based on these key/value pairs, unless the key starts with 'TranslationScope:'.<br>
     * If 'TranslationScope:CostEstimate' is present then it should contain the total cost estimate. Please specify currency as part of the value string.<br>
     * If 'TranslationScope:DetailsLink' is present then it should contain a link to the page which can provide the detailed scope.
     * This link can either be local(/apps/some-resource.html) or external (http://some-url-with-scope-details). Ideally the link should not require any further authentication.<br>
     * @return A map containing the scope information<br>
     * <br>
     * ICE Match - 90.85%<br>
     * 100% match - 4.04%<br>
     * 100-95% match - 0%<br>
     * 95-75% match - 0%<br>
     * 75-0% match - 5.1%<br>
     * Repetition - 0%<br>
     * TranslationScope:CostEstimate - 63.96 USD<br>
     * TranslationScope:DetailsLink - http://some-url-with-scope-details<br>
     */
    Map<String, String> getFinalScope();
}
