/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.translation.api.xliff;

import aQute.bnd.annotation.ConsumerType;
import org.w3c.dom.Document;

import java.io.IOException;
import java.io.InputStream;

/**
 * This service enables the translation platform to convert translation object XML to XLIFF and vice-versa
 */
@ConsumerType
public interface TranslationXLIFFService {

    /**
     * Converts an XML document, corresponding to a translation object, to an equivalent XLIFF string
     * @param xmlDocument XML document containing the content to be translated
     * @param id Unique id corresponding to the translation object from which the xmlDocument was created
     * @param sourceLanguage Source language of the translatable content inside xmlDocument
     * @param xliffVersion Version of the output XLIFF
     * @return String containing the complete XLIFF
     * @throws TranslationXLIFFServiceException
     */
    String convertXMLDocumentToXLIFFString(Document xmlDocument,
                                           String id,
                                           String sourceLanguage,
                                           String xliffVersion)
            throws TranslationXLIFFServiceException;

    /**
     * Converts an XLIFF InputStream to an equivalent XML
     * @param xliffInputStream Input XLIFF stream
     * @param sourceLanguage Source language
     * @param destinationLanguage Target language
     * @return XML Document
     * @throws TranslationXLIFFServiceException
     */
    Document convertXLIFFStreamToXMLDocument(InputStream xliffInputStream,
                                             String sourceLanguage,
                                             String destinationLanguage)
            throws TranslationXLIFFServiceException;
}
