/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.translation.api.xliff;

public class TranslationXLIFFServiceException extends Exception{

    private static final long serialVersionUID = 2833671272801743658L;

    /** The error code. */
    private ErrorCode errorCode = null;

    /** The message. */
    private String message = null;

    /**
     * Instantiates a new translation xliff service exception.
     * @param message the message
     * @param errorCode the error code
     */
    public TranslationXLIFFServiceException(final String message, final ErrorCode errorCode) {
        super(message);
        this.message = message;
        this.errorCode = errorCode;
    }

    /**
     * Instantiates a new translation xliff service exception.
     * @param message the message
     * @param throwable the throwable
     * @param errorCode the error code
     */
    public TranslationXLIFFServiceException(final String message, final Throwable throwable, final ErrorCode errorCode) {
        super(message, throwable);
        this.message = message;
        this.errorCode = errorCode;
    }

    /*
     * This method overrides the base Exception toString method and outputs the ErrorCode in conjunction with the
     * Exception message.
     */
    /*
     * (non-Javadoc)
     * @see java.lang.Throwable#toString()
     */
    @Override
    public String toString() {
        if (errorCode != null && message != null) {
            return "Error Code: " + errorCode + ".  Message: " + message;
        } else if (message != null) {
            return message;
        } else {
            return super.toString();
        }
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Throwable#getMessage()
     */
    @Override
    public String getMessage() {
        return message;
    }

    /**
     * Gets the error code.
     * @return the error code
     */
    public ErrorCode getErrorCode() {
        return errorCode;
    }

    /** The Enum ErrorCode. */
    public enum ErrorCode {

        /** General exception. */
        GENERAL_EXCEPTION,

        /** The translation xliff service is not available. */
        SERVICE_NOT_AVAILABLE,

        /** Not a valid XML. */
        INVALID_XML,

        /** Not a valid XLIFF. */
        INVALID_XLIFF,

        /** XLIFF version is not supported. */
        VERSION_NOT_SUPPORTED,

        /** Unsupported content encoding. */
        ENCODING_NOT_SUPPORTED,

        /** IO failure. */
        IO_EXCEPTION,

    }
}
