/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.translation.connector.msft.core;

import org.apache.http.impl.client.CloseableHttpClient;

public interface AccessToken {

    public String getAccessTokenString(CloseableHttpClient client);

    public String getTokenType();

    public String getTokenScope();

    public String getTokenValidTime();

    public long getTokenExpiredTime();

    public int getTimeOffset();

    public void setTimeOffset(int offset);

    public int getStatusCode();

    // The getter and setter methods for auth_url, grant_type and scope.
    // I implemented these methods in case MS will change/upgrade the service path or parameter values in the future.
    public String getAuthURL();

    public void setAuthURL(String url);

    public String getGrantType();

    public void setGrantType(String gtype);

    public String getScope();

    public void setScope(String s);

    public void setServiceParameters(String url, String gtype, String s);

    // Don't provide the getter methods for client information as they are confidential.
    // The user of access token MUST know these client information.
    public void setClientID(String id);

    public void setClientSecret(String secret);

    public void setClientParameters(String id, String secret);
}
