/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.translation.connector.msft.core;

import org.apache.jackrabbit.JcrConstants;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrosoftTranslationUtil {

    static private final Logger log = LoggerFactory.getLogger(MicrosoftTranslationUtil.class);

    static private String CLOUD_CONFIG_PROPERTY = "cq:cloudserviceconfigs";

    public static boolean isMicrosoftConfiguration(Resource translationConfigResource) {
        log.trace("In function: isMicrosoftConfiguration(Resource translationConfigResource)");
        Resource content = null;
        if (JcrConstants.JCR_CONTENT.equals(translationConfigResource.getName())) {
            content = translationConfigResource;
        } else {
            content = translationConfigResource.getChild(JcrConstants.JCR_CONTENT);
        }

        if (content != null) {
            return content.getResourceType().equals(MicrosoftTranslationCloudConfig.RESOURCE_TYPE);
        }
        return false;
    }

    public static MicrosoftTranslationCloudConfig getAppliedMicrosoftTranslationCloudConfigs(Resource resource) {
        if (resource == null) {
            return null;
        }

        log.trace("In Function: getAppliedMicrosoftTranslationCloudConfigs({})", resource.getPath());

        Resource content;
        String[] appliedCloudConfigs = null;
        ResourceResolver resolver = resource.getResourceResolver();

        boolean isContentNode = ResourceUtil.getName(resource.getPath()).equals(JcrConstants.JCR_CONTENT);
        if (!isContentNode) {
            content = resolver.getResource(resource, JcrConstants.JCR_CONTENT);
        } else {
            content = resource;
        }

        if (content != null) {

            if (log.isTraceEnabled()) {
                log.trace("Resource: {}", resource.getPath());
                log.trace("Content: {}", content.getPath());
            }

            try {
                appliedCloudConfigs = (String[]) ResourceUtil.getValueMap(content).get(CLOUD_CONFIG_PROPERTY);
            } catch (ClassCastException cce) {
                log.trace("Trying to cast as String as String[] failed");
                String singleValue = (String) ResourceUtil.getValueMap(content).get(CLOUD_CONFIG_PROPERTY);

                if (singleValue != null && !"".equals(singleValue)) {
                    appliedCloudConfigs = new String[1];
                    appliedCloudConfigs[0] = singleValue;
                }
            }

            if (appliedCloudConfigs != null) {

                MicrosoftTranslationCloudConfig mtcc = null;

                for (int i = 0; i < appliedCloudConfigs.length; i++) {

                    Resource appliedConfig = resolver.getResource(appliedCloudConfigs[i]);

                    if (appliedConfig != null) {
                        mtcc = appliedConfig.adaptTo(MicrosoftTranslationCloudConfig.class);
                    }

                    if (mtcc != null) {
                        log.trace("Found our MicrosoftTranslationCloudConfig {}", appliedCloudConfigs[i]);
                        return mtcc;
                    } else {
                        log.trace("Applied Cloud Config {} was not a MicrosoftTranslationCloudConfig.",
                            appliedCloudConfigs[i]);
                    }
                }

            }

        }

        return getParentAppliedMicrosoftTranslationCloudConfigs(resource);

    }

    private static MicrosoftTranslationCloudConfig getParentAppliedMicrosoftTranslationCloudConfigs(Resource resource) {
        if (resource == null) {
            return null;
        }

        log.trace("In Function: getParentAppliedMicrosoftTranslationCloudConfigs({})", resource.getPath());

        ResourceResolver resolver = resource.getResourceResolver();
        String parentPath = ResourceUtil.getParent(resource.getPath());

        if (null != parentPath) {
            Resource parent = resolver.getResource(parentPath);

            return getAppliedMicrosoftTranslationCloudConfigs(parent);
        }

        return null;
    }
}