/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.translation.core;

public interface MachineTranslationCloudConfig {

    /** Enum TranslationProviderWorkflow. */
    public static enum TranslationProviderWorkflow {
        /** machine translation */
        MACHINE_TRANSLATION,
        /** human translation */
        HUMAN_TRANSLATION,
        /** Machine Translation &amp; Post Edit Later */
        MACHINE_TRANSLATION_POST_EDIT_LATER,
        /** Machine Translation &amp; Post Edit before publishing */
        MACHIN_TRANSLATION_POST_EDIT_BEFORE_PUBLISH
    }

    public static enum TranslationEmbeddedAssetsWorkflow {
        /** DO not translate */
        DO_NOT_TRANSLATE,
        /** Use Sites workflow */
        USE_SITES_WORKFLOW,
        /** Use Assets workflow */
        USE_ASSETS_WORKFLOW
    }

    /*
     * first 3 items are from old cloud config 1.0, we have kept the name and value same for backward compatibility
     */
    /*
     * COMMUNITIES tab config values
     */
    public static final String PROPERTY_DEFAULT_TRANSLATION_PROVIDER = "defaultTranslationProvider";
    public static final String PROPERTY_DEFAULT_CATEGORY = "defaultCategory";
    public static final String PROPERTY_UGC_PATH = "ugcPath";

    /*
     * SITES tab config values
     */
    public static final String PROPERTY_SITES_DEFAULT_TRANSLATION_WORKFLOW = "sites_translationWorkflow";
    public static final String PROPERTY_SITES_DEFAULT_TRANSLATION_PROVIDER = "sites_defaultTranslationProvider";
    public static final String PROPERTY_SITES_DEFAULT_POST_EDIT_PROVIDER = "sites_defaultPostEditProvider";
    public static final String PROPERTY_SITES_DEFAULT_CATEGORY = "sites_defaultCategory";
    public static final String PROPERTY_SITES_TRANSLATE_METADATA = "sites_translateMetadata";
    public static final String PROPERTY_SITES_TRANSLATE_COMPONENT_STRING = "sites_translateComponentStrings";
    public static final String PROPERTY_SITES_TRANSLATE_TAGS = "sites_translateTags";
    public static final String PROPERTY_SITES_TRANSLATE_EMBEDDED_ASSETS = "sites_translateEmbeddedAssets";
    public static final String PROPERTY_SITES_AUTO_EXECUTE_TRANSLATION_WORKFLOW =
        "sites_autoexecuteTranslationWorkflow";

    /*
     * ASSETS tab config values
     */
    public static final String PROPERTY_ASSETS_DEFAULT_TRANSLATION_WORKFLOW = "assets_translationWorkflow";
    public static final String PROPERTY_ASSETS_DEFAULT_TRANSLATION_PROVIDER = "assets_defaultTranslationProvider";
    public static final String PROPERTY_ASSETS_DEFAULT_POST_EDIT_PROVIDER = "assets_defaultPostEditProvider";
    public static final String PROPERTY_ASSETS_DEFAULT_CATEGORY = "assets_defaultCategory";
    public static final String PROPERTY_ASSETS_TRANSLATE_ASSETS = "assets_translateAssets";
    public static final String PROPERTY_ASSETS_TRANSLATE_METADATA = "assets_translateMetadata";
    public static final String PROPERTY_ASSETS_TRANSLATE_TAGS = "assets_translateTags";
    public static final String PROPERTY_ASSETS_AUTO_EXECUTE_TRANSLATION_WORKFLOW =
        "assets_autoexecuteTranslationWorkflow";

    public static final String RESOURCE_TYPE = "cq/translation/components/mt-cloudconfig";

    @Deprecated
    String getDefaultTranslationProvider();

    @Deprecated
    String getDefaultCategory();

    @Deprecated
    String getUgcPath();

    // Section for Communities
    String getDefaultTranslationProviderForCommunities();

    String getDefaultCategoryForCommunities();

    String getUgcPathForCommunities();

    // Section for Sites
    TranslationProviderWorkflow getDefaultTranslationProviderWorkflowForSites();

    String getDefaultTranslationProviderForSites();

    String getDefaultPostEditProviderForSites();

    String getDefaultCategoryForSites();

    boolean isTranslateMetadataForSites();

    boolean isTranslationEnabledForSites();

    boolean isTranslateComponentStringsForSites();

    boolean isTranslateTagsForSites();

    TranslationEmbeddedAssetsWorkflow getEmbeddedAssetsWorkflow();

    boolean isAutoExecuteTranslationWorkflowForSites();

    // Section for Assets
    TranslationProviderWorkflow getDefaultTranslationProviderWorkflowForAssets();

    String getDefaultTranslationProviderForAssets();

    String getDefaultPostEditProviderForAssets();

    String getDefaultCategoryForAssets();

    boolean isTranslateMetadataForAssets();

    boolean isTranslateAssetsAllowedForAssets();

    boolean isTranslateTagsForAssets();

    boolean isTranslationEnabledForAssets();

    boolean isAutoExecuteTranslationWorkflowForAssets();

}