/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.translation.core.common;

import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationResultImpl implements TranslationResult {

    private static final Logger log = LoggerFactory.getLogger(TranslationResultImpl.class);

    public static int UNKNOWN_RATING = -999;

    private String translation;
    private String sourceLang;
    private String targetLang;
    private TranslationConstants.ContentType contentType;
    private String category;
    private String source;
    private int rating;
    private String userId;

    public TranslationResultImpl(String translation, String sourceLang, String targetLang,
        TranslationConstants.ContentType contentType, String category, String source, int rating, String userId) {
        log.trace("In function: TranslationResultImpl");

        this.translation = translation;
        this.sourceLang = sourceLang;
        this.targetLang = targetLang;
        this.contentType = contentType;
        this.category = category;
        this.source = source;
        this.rating = rating;
        this.userId = userId;

        if (log.isDebugEnabled()) {
            log.debug("translation: {}", translation);
            log.debug("sourceLang: {}", sourceLang);
            log.debug("targetLang: {}", targetLang);
            log.debug("contentType: {}", contentType.getType());
            log.debug("category: {}", category);
            log.debug("source: {}", source);
            log.debug("rating: {}", rating);
            log.debug("userId: {}", userId);
        }
    }

    @Override
    public String getTranslation() {
        return translation;
    }

    @Override
    public String getSourceLanguage() {
        return sourceLang;
    }

    @Override
    public String getTargetLanguage() {
        return targetLang;
    }

    @Override
    public TranslationConstants.ContentType getContentType() {
        return contentType;
    }

    @Override
    public String getCategory() {
        return category;
    }

    @Override
    public String getSourceString() {
        return source;
    }

    @Override
    public int getRating() {
        return rating;
    }

    @Override
    public String getUserId() {
        return userId;
    }

}