/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.clientlibs;

import java.util.Map;
import java.util.Set;

import aQute.bnd.annotation.ProviderType;

/**
 * <code>ClientLibrary</code> represents a client library as defined in
 * content. a client library can have categories, dependencies and produce
 * different types of html libraries.
 *
 * @since 5.4
 */
@ProviderType
public interface ClientLibrary {

    /**
     * Returns the path of this library
     * @return the path
     */
    String getPath();

    /**
     * Returns the include path of this library for the given type. If the library
     * does not support the given type, <code>null</code> is returned.
     * @param type library type
     * @return the include path
     */
    String getIncludePath(LibraryType type);

    /**
     * Returns the include path of this library for the given type. If the library
     * does not support the given type, <code>null</code> is returned.
     * @param type library type
     * @param minified <code>true</code> to return the path to the minified version
     * @return the include path
     * @since 5.5.30
     */
    String getIncludePath(LibraryType type, boolean minified);

    /**
     * Returns the set of types that this library provides.
     * @return the types
     */
    Set<LibraryType> getTypes();

    /**
     * Returns the theme name in case this is a themed library.
     * @return the theme name or <code>null</code>
     */
    String getThemeName();

    /**
     * Returns the library id in case this is a themed library
     * @return the library id or <code>null</code>
     */
    String getThemeLibId();

    /**
     * Returns the categories this library is registered for.
     * @return the categories
     */
    String[] getCategories();

    /**
     * Returns the categories of the embedded libraries
     * @return the embedded categories
     */
    String[] getEmbeddedCategories();

    /**
     * Returns the categories of the dependent libraries
     * @return the embedded categories
     */
    String[] getDependentCategories();

    /**
     * Returns the channels associated with this library
     * @return the channels
     */
    String[] getChannels();

    /**
     * Resolves the dependencies of this library. resolves recursively,
     * if transitive is <code>true</code>.
     *
     * @param transitive <code>true</code> for recursive resolution
     * @return the map of libraries
     */
    Map<String, ? extends ClientLibrary> getDependencies(boolean transitive);

    /**
     * Returns the embedded libraries filtered by type.
     * Note that if this is a themed library, only themed dependencies are
     * returned and vice-versa.
     *
     * @param type type filter
     * @return the map of libraries
     */
    Map<String, ? extends ClientLibrary> getEmbedded(LibraryType type);

    /**
     * Flag indicating if proxying is allowed.
     * @return <code>true</code> if proxy is allowed.
     * @since 5.5.38
     */
    boolean allowProxy();
}