/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.clientlibs;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;

import aQute.bnd.annotation.ProviderType;

/**
 * <code>HtmlLibrary</code> represents a JS or CSS library that is assembled
 * dynamically be a bunch of files.
 */
@ProviderType
public interface HtmlLibrary {

    /**
     * Returns the include path of this library. eg: "/libs/cq/ui/widgets.js"
     * @return the include path.
     */
    String getPath();

    /**
     * Returns the include path of this library. eg: "/libs/cq/ui/widgets.js"
     * @param minified <code>true</code> to return the path to the minified version. e.g. "/libs/cq/ui/widgets.min.js"
     * @return the include path.
     * @since 5.5.30
     */
    String getPath(boolean minified);

    /**
     * Returns the library path of this library. eg: "/libs/cq/ui/widgets"
     * @return the library path
     */
    String getLibraryPath();

    /**
     * Returns the (final) name of this library. eg: "widgets.js"
     * @return the library name
     */
    String getName();

    /**
     * Returns the (final) name of this library. eg: "widgets.js"
     * @param minified <code>true</code> to return the minified name. eg "widgets.min.js"
     * @return the library name
     * @since 5.5.30
     */
    String getName(boolean minified);

    /**
     * Returns the library type
     * @return the library type
     */
    LibraryType getType();

    /**
     * Returns the lastModified date of this library
     * @return last modified date as long
     */
    long getLastModified();

    /**
     * Returns the lastModified date of this library
     * @param minified <code>true</code> to return the last modified date of the minified version
     * @return last modified date as long
     * @since 5.5.30
     */
    long getLastModified(boolean minified);

    /**
     * send the input stream of the generated lib to the response
     * of it's response object and sets the following headers:
     * <ul>
     * <li> <code>Last-Modified</code>
     * <li> <code>Content-Type</code>
     * <li> <code>Content-Encoding</code>
     * </ul>
     *
     * @param response servlet response
     * @param gzipped <code>true</code> if the response should be compressed
     * @throws java.io.IOException is thrown in case the copy operation fails
     * @deprecated use {@link #send(org.apache.sling.api.SlingHttpServletRequest, org.apache.sling.api.SlingHttpServletResponse)}
     */
    @Deprecated
    void send(HttpServletResponse response, boolean gzipped) throws IOException;

    /**
     * send the input stream of the generated lib to the response. Handles "if-modified-since", sets the response
     * content type and encoding headers and cache-control header as configured in the html library manager.
     *
     * @param request servlet request
     * @param response servlet response
     * @throws java.io.IOException is thrown in case the copy operation fails
     * @since 5.5.30
     */
    void send(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException;

    /**
     * Returns the input stream of the generated lib file
     *
     * @return input stream
     * @throws java.io.IOException if the stream cannot be acquired
     */
    InputStream getInputStream() throws IOException;

    /**
     * Returns the input stream of the generated lib file
     * @param minified <code>true</code> to return the stream to the minified version
     * @return input stream
     * @throws java.io.IOException if the stream cannot be acquired
     * @since 5.5.30
     */
    InputStream getInputStream(boolean minified) throws IOException;

    /**
     * Returns a list of all script paths.
     *
     * @return list of files
     */
    List<String> getScripts();

    /**
     * Returns a list of absolute paths to the scripts as a delimiter separated list.
     * @param delimiter the delimiter
     * @return the list of scripts
     */
    String getScripts(String delimiter);
}