/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.clientlibs.script;

import java.util.Collection;

import aQute.bnd.annotation.ProviderType;

/**
 * {@code CompilerContext}...
 */
@ProviderType
public interface CompilerContext {

    /**
     * Returns a resource provider for resolving external resources during compilation.
     * @return a resource provider.
     */
    ScriptResourceProvider getResourceProvider();

    /**
     * Returns the path of the compiler output <em>file</em>.
     * @return the path
     */
    String getDestinationPath();

    /**
     * The dependencies can be updated by the compiler to add paths to dependant resources, for example external imports.
     * @return the collection of dependencies
     */
    Collection<String> getDependencies();
}