/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.clientlibs.script;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;

import aQute.bnd.annotation.ConsumerType;

/**
 * <code>Compiler</code> defines a generic compiler.
 */
@ConsumerType
public interface ScriptCompiler {

    /**
     * Name of this compiler.
     * @return the name
     */
    String getName();

    /**
     * Checks if this compiler handles the file with the given extension
     * @param extension extension, eg 'less'
     * @return {@code true} if this compiler handles the extension
     */
    boolean handles(String extension);

    /**
     * Returns the mime type of the output file.
     * @return the mime type.
     */
    String getMimeType();

    /**
     * Returns the extension of the output file
     * @return the extension of the output file. eg. 'css'
     */
    String getOutputExtension();

    /**
     * Compiles a given collection of resources.
     *
     * @param src resource to compile
     * @param dst writer to write the compiled output
     * @param ctx the compiler context
     * @throws IOException of an I/O error occurs
     */
    void compile(Collection<ScriptResource> src, Writer dst, CompilerContext ctx) throws IOException;

}