/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.clientlibs.script;

import java.io.IOException;
import java.io.Reader;

import aQute.bnd.annotation.ProviderType;

/**
 * Defines a script resource
 */
@ProviderType
public interface ScriptResource {

    /**
     * Gets the name (path) of the resource
     * @return the name
     */
    String getName();

    /**
     * Opens a reader to this resource
     * @return an open reader
     * @throws IOException if an error occurs
     */
    Reader getReader() throws IOException;

    /**
     * Returns the size of this resource
     * @return the size
     */
    long getSize();

}