/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.components;

import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.Cookie;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

/**
 * Is a toolkit to receive the client state for DOM attributes out of Coral UI's util.state.
 * It's purpose is to receive the values from the HTTP request and either transform it to
 * an JSON object or to add them to an existing AttrBuilder
 * 
 * @deprecated CoralUI v1 specific
 */
@Deprecated
public class ClientState {

    private final String COOKIE_NAME = "cui-state";
    private final String STATE_GLOBAL_NAMESPACE = "global";

    private JSONObject json = null;

    public ClientState(SlingHttpServletRequest slingRequest) {
        Cookie cookie = slingRequest.getCookie(COOKIE_NAME);

        try {
            String cookieVal = URLDecoder.decode(cookie.getValue(), "UTF-8");
            json = new JSONObject(cookieVal);
        } catch (Exception ex) {
            json = null;
        }
    }

    private void addAttribute(AttrBuilder attr, String attribute, JSONObject attributeJson) throws JSONException {
        if ("class".equals(attribute)) { // attribute "class"
            String attrClass = attributeJson.optString("val");

            String[] attrClassList = attrClass.split("\\s+");
            for (String anAttrClassList : attrClassList) {
                attr.addClass(anAttrClassList);
            }
        } else if ("rel".equals(attribute)) { // attribute "rel"
            String attrRel = attributeJson.optString("val");
            attr.addRel(attrRel);
        } else if ("href".equals(attribute)) { // attribute "href"
            String attrHref = attributeJson.optString("val");
            attr.addHref(attribute, attrHref);
        } else if (attribute.matches("^data-.+")) { // attribute data-*
            String attrData = attributeJson.optString("val");
            attr.addOther(attribute.replaceFirst("^data-.+", ""), attrData);
        } else if (attributeJson.optBoolean("val")) { // String is a boolean
            attr.addBoolean(attribute, attributeJson.getBoolean("val"));
        } else { // String
            String attrString = attributeJson.optString("val");
            attr.add(attribute, attrString);
        }
    }

    /**
     * Returns all attributes from the global namespace for the given selector
     *
     * @param selector the selector
     * @return all attributes from the global namespace for the given selector
     */
    public JSONObject getState(String selector) {
        return getState(selector, STATE_GLOBAL_NAMESPACE);
    }

    /**
     * Returns all attributes from a given namespace for the given selector
     *
     * @param selector the selector
     * @param namespace the namespace
     * @return all attributes from the given namespace for the given selector
     */
    public JSONObject getState(String selector, String namespace) {
        try {
            JSONObject namespaceJson = json.getJSONObject(namespace);
            JSONObject selectorJson = namespaceJson.getJSONObject(selector);

            return selectorJson;
        } catch (Exception ex) {
            return null;
        }
    }

    /**
     * Returns all attributes which keys are included in the attributes array
     * from the global namespace for the given selector
     *
     * @param selector the selector
     * @param attributes the keys of the attributes we are interested in
     * @return all attributes which keys are included in the attributes array
     *         from the global namespace for the given selector
     */
    public JSONObject getState(String selector, String[] attributes) {
        return getState(selector, attributes, STATE_GLOBAL_NAMESPACE);
    }

    /**
     * Returns all attributes which keys are included in the attributes array
     * from a given namespace for the given selector
     *
     * @param selector the selector
     * @param attributes the keys of the attributes we are interested in
     * @param namespace the namespace
     * @return all attributes which keys are included in the attributes array
     *         from a given namespace for the given selector
     */
    public JSONObject getState(String selector, String[] attributes, String namespace) {
        try {
            List<String> attrList = null;
            if (attributes != null) {
                attrList = Arrays.asList(attributes);
            }

            JSONObject selectorJson = getState(selector, namespace);
            Iterator<String> keys = selectorJson.keys();

            while (keys.hasNext()) {
                String attribute = keys.next();

                // delete all attributes which are not in the list
                if (attrList != null && !attrList.contains(attribute)) {
                    selectorJson.remove(attribute);
                }
            }

            return selectorJson;
        } catch (Exception ex) {
            return null;
        }
    }

    /**
     * Adds all attributes from the global namespace for the given selector to an AttrBuilder
     *
     * @param attr the attribute builder
     * @param selector the selector
     * @return {@code true} if the addition was successful, {@code false} otherwise
     */
    public boolean restoreState(AttrBuilder attr, String selector) {
        return restoreState(attr, selector, STATE_GLOBAL_NAMESPACE);
    }

    /**
     * Adds all attributes from a given namespace for the given selector to an AttrBuilder
     *
     * @param attr the attribute builder
     * @param selector the selector
     * @param namespace the namespace
     * @return {@code true} if the addition was successful, {@code false} otherwise
     */
    public boolean restoreState(AttrBuilder attr, String selector, String namespace) {
        return restoreState(attr, selector, null, namespace);
    }

    /**
     * Adds all attributes which keys are included in the attributes array
     * from the global namespace for the given selector to an AttrBuilder
     *
     * @param attr the attribute builder
     * @param selector the selector
     * @param attributes the attributes
     * @return {@code true} if the addition was successful, {@code false} otherwise
     */
    public boolean restoreState(AttrBuilder attr, String selector, String[] attributes) {
        return restoreState(attr, selector, attributes, STATE_GLOBAL_NAMESPACE);
    }

    /**
     * Adds all attributes which keys are included in the attributes array
     * from a given namespace for the given selector to an AttrBuilder
     *
     * @param attr the attribute builder
     * @param selector the selector
     * @param attributes the attributes
     * @param namespace the namespace
     * @return {@code true} if the addition was successful, {@code false} otherwise
     */
    public boolean restoreState(AttrBuilder attr, String selector, String[] attributes, String namespace) {
        try {
            JSONObject selectorJson = getState(selector, attributes, namespace);
            Iterator<String> keys = selectorJson.keys();

            while (keys.hasNext()) {
                String attribute = keys.next();
                JSONObject attributeJson = selectorJson.getJSONObject(attribute);

                addAttribute(attr, attribute, attributeJson);
            }

            return true;
        } catch (Exception ex) {
            return false;
        }
    }
}
