/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.components;

import java.util.Locale;

import javax.servlet.jsp.PageContext;

/**
 * A helper to deal with EL easier.
 */
public class ExpressionHelper {
    private ExpressionResolver resolver;

    private PageContext pageContext;

    public ExpressionHelper(ExpressionResolver resolver, PageContext pageContext) {
        this.resolver = resolver;
        this.pageContext = pageContext;
    }

    /**
     * Resolves the given expression as string. Request's locale will be used.
     * @param expression the expression to be resolved
     * @return the resolved expression as a string
     */
    public String getString(String expression) {
        return get(expression, String.class);
    }

    /**
     * Resolves the given expression as string, with the given locale.
     * @param expression the expression to be resolved
     * @param locale the locale
     * @return the resolved expression as a string
     */
    public String getString(String expression, Locale locale) {
        return get(expression, locale, String.class);
    }

    /**
     * Resolves the given expression as boolean. Request's locale will be used.
     * @param expression the expression to be resolved
     * @return the resolved expression as a boolean
     */
    public boolean getBoolean(String expression) {
        return get(expression, Boolean.class);
    }

    /**
     * Resolves the given expression as boolean, with the given locale.
     * @param expression the expression to be resolved
     * @param locale the locale
     * @return the resolved expression as a boolean
     */
    public boolean getBoolean(String expression, Locale locale) {
        return get(expression, locale, Boolean.class);
    }

    /**
     * Resolves the given expression. Request's locale will be used.
     * @param expression the expression to be resolved
     * @param expectedType the expected type of the resolved expression
     * @param <T> the type of the resolved expression
     * @return the resolved expression
     */
    public <T> T get(String expression, Class<T> expectedType) {
        return get(expression, pageContext.getRequest().getLocale(), expectedType);
    }

    /**
     * Resolves the given expression, with the given locale.
     * @param expression the expression to be resolved
     * @param locale the locale
     * @param expectedType the expected type of the resolved expression
     * @param <T> the type of the resolved expression
     * @return the resolved expression
     */
    public <T> T get(String expression, Locale locale, Class<T> expectedType) {
        if (expression == null) return null;
        
        return resolver.resolve(expression, locale, expectedType, pageContext);
    }
}
