/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.components;

import java.util.Locale;

import javax.servlet.jsp.PageContext;

/**
 * A service to resolve an expression into an actual object.
 */
public interface ExpressionResolver {

    /**
     * Resolves the given expression.
     * @param expression the expression to be resolved
     * @param locale the locale
     * @param expectedType the expected type of the resolved expression
     * @param <T> the type of the resolved expression
     * @param pageContext the page context
     * @return the given expression
     */
    <T> T resolve(String expression, Locale locale, Class<T> expectedType, PageContext pageContext);

}
