/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.components;

import java.util.Iterator;

/**
 * A wrapper iterator to supports paging.
 */
public class PagingIterator<E> implements Iterator<E> {
    private Iterator<E> it;

    private Integer offset;

    private Integer limit;

    private int limitCounter = 0;

    public PagingIterator(Iterator<E> it, Integer offset, Integer limit) {
        this.it = it;
        this.offset = offset;
        this.limit = limit;

        if (offset != null && offset < 0) {
            throw new IllegalArgumentException("offset is negative");
        }

        if (limit != null && limit < 0) {
            throw new IllegalArgumentException("limit is negative");
        }

        doOffset();
    }

    private void doOffset() {
        if (offset == null) return;

        for (int i = 0; i < offset && it.hasNext(); i++) {
            it.next();
        }
    }

    public boolean hasNext() {
        if (limit == null) {
            return it.hasNext();
        }

        return limitCounter < limit && it.hasNext();
    }

    public E next() {
        E next = it.next();
        limitCounter++;
        return next;
    }

    public void remove() {
        it.remove();
    }
}
