/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.components;

import java.io.IOException;
import java.io.Writer;

/**
 * A representation of DOM tag. A tag has a name (e.g. div, span) and a set of attributes.
 */
public class Tag {
    private String name;

    private AttrBuilder attrs;

    /**
     * Creates a tag with the given name and attributes.
     * @param name the name of the tag
     * @param attrs the attributes
     */
    public Tag(String name, AttrBuilder attrs) {
        this.name = name;
        this.attrs = attrs;
    }

    /**
     * Creates a tag with the given attributes. The name is <code>null</code> in this case.
     * @param attrs the attributes
     */
    public Tag(AttrBuilder attrs) {
        this.attrs = attrs;
    }

    /**
     * Returns the name of the tag (e.g. div, span).
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the name of the tag.
     * @param name the name
     * @return the tag
     */
    public Tag setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Returns the attributes of the tag.
     * @return the attributes of the tag
     */
    public AttrBuilder getAttrs() {
        return attrs;
    }

    /**
     * Sets attributes of the tag.
     * @param attrs the attributes to set
     * @return the tag with the newly set attributes
     */
    public Tag setAttrs(AttrBuilder attrs) {
        this.attrs = attrs;
        return this;
    }

    /**
     * Println the start tag of this tag (e.g. {@code "<div class='class1'>"}). Note that no escaping/encoding of the name
     * is performed.
     * @param out the writer
     * @return the tag
     * @throws java.io.IOException if there's a problem while printing to the writer
     */
    public Tag printlnStart(Writer out) throws IOException {
        out.append("<").append(name);

        if (!attrs.isEmpty()) {
            out.append(" ");
            attrs.build(out);
        }

        out.append(">\n");
        return this;
    }

    /**
     * Println the end tag of this tag (e.g. "&lt;/div&gt;"). Note that no escaping/encoding of the name is performed.
     * @param out the writer
     * @return the tag
     * @throws java.io.IOException if there's a problem while printing to the writer
     */
    public Tag printlnEnd(Writer out) throws IOException {
        out.append("</").append(name).append(">\n");
        return this;
    }
}
