/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.components;

import java.util.HashMap;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

/**
 * <code>ValueMapResourceWrapper</code> wraps a resource with an empty <code>ValueMap</code> to allow resources
 * with dynamic properties.
 */
public class ValueMapResourceWrapper extends ResourceWrapper {

    private ValueMap vm = new ValueMapDecorator(new HashMap<String, Object>());
    private String resourceType;

    /**
     * Creates a new wrapper for the given resource and the given type.
     * @param resource The resource to wrap
     * @param resourceType The type
     */
    public ValueMapResourceWrapper(Resource resource, String resourceType) {
        super(resource);
        this.resourceType = resourceType;
        vm.put("sling:resourceType", resourceType);
    }

    /**
     * {@inheritDoc}
     */
    public String getResourceType() {
        return resourceType;
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (ValueMap.class.equals(type)) {
            return (AdapterType) vm;
        } else {
            return super.adaptTo(type);
        }
    }

    /**
     * {@inheritDoc}
     */
    public ValueMap getValueMap() {
        return vm;
    }
}
