/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.components.ds;

import java.util.Iterator;

import org.apache.sling.api.resource.Resource;

/**
 * DataSource is an abstract collection of {@link Resource}.
 * 
 * Implementor of {@link DataSource} is encouraged to use
 * {@link AbstractDataSource} to ensure to always be able to support new methods
 * that might be introduced in this interface in the future.
 */
public interface DataSource {

    /**
     * Returns the data.
     * @return the data as an iterator
     */
    Iterator<Resource> iterator();
}
