/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.components.ds;

import java.util.Iterator;
import java.util.NoSuchElementException;

import org.apache.sling.api.resource.Resource;

/**
 * A datasource that has empty data.
 */
public final class EmptyDataSource implements DataSource {
    private static DataSource instance;

    /**
     * Returns the singleton instance.
     * @return the singleton instance
     */
    public static DataSource instance() {
        if (instance == null) {
            instance = new EmptyDataSource();
        }

        return instance;
    }

    private EmptyDataSource() {
    }

    public Iterator<Resource> iterator() {
        return new Iterator<Resource>() {
            public void remove() {
                throw new UnsupportedOperationException("Empty iterator");
            }

            public Resource next() {
                throw new NoSuchElementException("Empty iterator");
            }

            public boolean hasNext() {
                return false;
            }
        };
    }
}
