/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.components.ds;

import java.util.Iterator;

import org.apache.commons.collections.iterators.ListIteratorWrapper;
import org.apache.sling.api.resource.Resource;

/**
 * A datasource that simply takes the passed resource iterator as its data.
 */
public class SimpleDataSource extends AbstractDataSource {
    private final ListIteratorWrapper wrapper;

    public SimpleDataSource(Iterator<Resource> iterator) {
        this.wrapper = new ListIteratorWrapper(iterator);
    }

    @SuppressWarnings("unchecked")
    public Iterator<Resource> iterator() {
        wrapper.reset();
        return wrapper;
    }
}
