/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.granite.ui.components.formbuilder;

import java.util.HashMap;

import org.apache.sling.api.resource.Resource;

public interface FormResourceManager {

    /**
     * Returns a generic form field resource
     * @param formResource the form resource
     * @return a generic form field resource
     */
    Resource getFormFieldResource(Resource formResource);

    /**
     * Returns a generic form field resource
     * @param formResource the form resource
     * @param label the label
     * @return a generic form field resource
     */
    Resource getFormFieldResource(Resource formResource, String label);

    /**
     * Returns a form drop down resource
     * @param formResource the form resource
     * @return a form drop down resource
     */
    Resource getFormDropdownResource(Resource formResource);

    /**
     * Returns a drop down option resource
     * @param formResource the form resource
     * @return a drop down option resource
     */
    Resource getDropdownOptionResource(Resource formResource);

    /**
     * Returns a checkbox field resource
     * @param formResource the form resource
     * @return a checkbox field resource
     */
    Resource getCheckboxFieldResource(Resource formResource);

    /**
     * Returns a checkbox field resource
     * @param formResource the form resource
     * @param label the label
     * @return a checkbox field resource
     */
    Resource getCheckboxFieldResource(Resource formResource, String label);

    /**
     * Returns a date field resource
     * @param formResource the form resource
     * @return a date field resource
     */
    Resource getDateFieldResource(Resource formResource);

    /**
     * Returns a default date resource
     * @param formResource the form resource
     * @return a default date resource
     */
    Resource getDefaultDateResource(Resource formResource);

    /**
     * Returns a default date resource
     * @param formResource the form resource
     * @param label the label
     * @return a default date resource
     */
    Resource getDefaultDateResource(Resource formResource, String label);

    /**
     * Returns a hidden field resource
     * @param formResource the form resource
     * @return a hidden field resource
     */
    Resource getHiddenFieldResource(Resource formResource);

    /**
     * Returns a default property field resource
     * @param formResource the form resource
     * @param values the values
     * @return a default property field resource
     */
    Resource getDefaultPropertyFieldResource(Resource formResource, HashMap<String, Object> values);

    /**
     * Returns the field template id used by external resources
     * @return the field template id used by external resources
     */
    String getFieldTemplateID();

    /**
     * Returns the dropdown option key used by external resources
     * @return the dropdown option key used by external resources
     */
    String getOptionTemplateID();

    /**
     * Returns the list order key used by external resources
     * @return the list order key used by external resources
     */
    String getOrderKey();
}
