/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.components.rendercondition;

import java.io.IOException;
import java.util.HashMap;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.jcr.resource.JcrResourceConstants;

/**
 * A condition that act as an aggregate using composite pattern. The child
 * resources are evaluated recursively to finally come up with final decision.
 */
public abstract class AbstractCompositeRenderCondition implements RenderCondition {
    protected SlingHttpServletRequest request;
    protected SlingHttpServletResponse response;
    protected Resource resource;

    public AbstractCompositeRenderCondition(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource) {
        this.request = request;
        this.response = response;
        this.resource = resource;
    }

    /**
     * Calls the given render condition resource.
     * @param resource the resource
     * @return the render condition
     * @throws javax.servlet.ServletException in case a servlet error occurs
     * @throws java.io.IOException in case an error occurs during IO
     */
    protected RenderCondition call(Resource resource) throws ServletException, IOException {
        try {
            ValueMap vm = resource != null ? resource.getValueMap() : new ValueMapDecorator(new HashMap<String, Object>());
            String resourceType = vm.get(JcrResourceConstants.SLING_RESOURCE_TYPE_PROPERTY, "granite/ui/components/foundation/renderconditions/simple");

            RequestDispatcher dispatcher = request.getRequestDispatcher(resource, new RequestDispatcherOptions(resourceType));

            if (dispatcher != null) {
                dispatcher.include(request, response);

                RenderCondition condition = (RenderCondition) request.getAttribute(RenderCondition.class.getName());
                if (condition != null) {
                    return condition;
                }
            }

            return SimpleRenderCondition.TRUE;
        } finally {
            request.removeAttribute(RenderCondition.class.getName());
        }
    }
}
