/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.components.rendercondition;

import java.io.IOException;
import java.util.Iterator;

import javax.servlet.ServletException;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;

/**
 * The condition that returns <code>true</code> when all the sub conditions are
 * returning <code>true</code>; <code>false</code> otherwise.
 */
public class AndRenderCondition extends AbstractCompositeRenderCondition {
    public AndRenderCondition(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource) {
        super(request, response, resource);
    }

    public boolean check() throws ServletException, IOException {
        for (Iterator<Resource> it = resource.listChildren(); it.hasNext();) {
            if (!call(it.next()).check()) {
                return false;
            }
        }

        return true;
    }
}
