/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.components.rendercondition;

import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import javax.servlet.ServletException;

/**
 * A condition that decides based on
 * {@link AccessControlManager#hasPrivileges(String, Privilege[])}.
 */
public class PrivilegeRenderCondition implements RenderCondition {
    private AccessControlManager acm;
    private String path;
    private Privilege[] privileges;

    public PrivilegeRenderCondition(AccessControlManager acm, String path, String[] privilegeNames) throws RepositoryException {
        this.acm = acm;
        this.path = path;
        this.privileges = converts(privilegeNames);
    }

    public PrivilegeRenderCondition(AccessControlManager acm, String path, Privilege[] privileges) {
        this.acm = acm;
        this.path = path;
        this.privileges = privileges;
    }

    private Privilege[] converts(String[] privilegeNames) throws RepositoryException {
        Privilege[] privileges = new Privilege[privilegeNames.length];

        for (int i = 0; i < privilegeNames.length; i++) {
            privileges[i] = acm.privilegeFromName(privilegeNames[i]);
        }

        return privileges;
    }

    public boolean check() throws ServletException {
        try {
            return acm.hasPrivileges(path, privileges);
        } catch (RepositoryException e) {
            return false;
        }
    }
}
