/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.components.rendercondition;

import java.io.IOException;

import javax.servlet.ServletException;

/**
 * The condition if the component should be rendered or not.
 */
public interface RenderCondition {
    /**
     * Returns <code>true</code> if the component should be rendered.
     * <code>false</code> otherwise.
     * @return {@code true} if the component should be rendered, 
     * {@code false} otherwise
     * @throws javax.servlet.ServletException in case a servlet error occurs
     * @throws java.io.IOException in case an error occurs during IO
     */
    boolean check() throws ServletException, IOException;
}
