/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.components.rendercondition;

/**
 * A condition that takes a simple boolean for the decision.
 */
public final class SimpleRenderCondition implements RenderCondition {
    /**
     * The condition that is always return <code>true</code>.
     */
    public static final RenderCondition TRUE = new SimpleRenderCondition(true);

    /**
     * The condition that is always return <code>false</code>.
     */
    public static final RenderCondition FALSE = new SimpleRenderCondition(false);

    private boolean decision;

    /**
     * Creates an instance based on the given decision.
     * @param decision the decision
     */
    public SimpleRenderCondition(boolean decision) {
        this.decision = decision;
    }

    public boolean check() {
        return decision;
    }
}
