/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.collection;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import java.util.List;

/**
 * The <code>ResourceCollection</code> represents a collection of jcr resources (nodes)
 * which can be added/removed.
 * The collection is also able to listen to (jcr) modifications undertaken by
 * a certain user. this modifications respectively the modified resource is added
 * to the list as well.
 */
public interface ResourceCollection {

    /**
     * Name of the node containing filter definitions' items
     */
    public static final String NN_FILTER = "filter";

    /**
     * Property name of a filter's item root path
     */
    public static final String PN_FILTER_ROOT = "root";

    /**
     * All collection members are retourned
     *
     * @param allowedNodesTypes list of node types to be considered
     *
     * @return a list of all members
     *
     * @throws javax.jcr.RepositoryException in case an error occurs while
     *         fetching the list.
     */
    List<Node> list(String[] allowedNodesTypes) throws RepositoryException;

    /**
     * Remove member
     *
     * @param node node to remove
     */
    void remove(Node node);

    /**
     * Returns collection path
     * @return collection path
     */
    String getPath();
}
