/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.collection;

import aQute.bnd.annotation.ProviderType;

import javax.jcr.Node;
import javax.jcr.Session;
import java.util.List;

/**
 * The <code>ResourceCollectionManager</code> can read, list all available
 * resource collections respectovely manage the resource collections...
 */
@ProviderType
public interface ResourceCollectionManager {
    /**
     * Creates a {@link com.adobe.granite.workflow.collection.ResourceCollection} object
     * from the given node if possible.
     *
     * @param node node to create {@link com.adobe.granite.workflow.collection.ResourceCollection} object
     * @return {@link com.adobe.granite.workflow.collection.ResourceCollection} or <code>
     * null</code> if the node can not be turned into such an object.
     */
    ResourceCollection createCollection(Node node);

    /**
     * Lists all available {@link com.adobe.granite.workflow.collection.ResourceCollection}s
     * which are accessible be the given {@link Session}
     *
     * @param session user session
     * @return all available {@link com.adobe.granite.workflow.collection.ResourceCollection}s
     */
    List<ResourceCollection> getCollections(Session session);

    /**
     * List all available {@link com.adobe.granite.workflow.collection.ResourceCollection}s for the given {@link
     * javax.jcr.Node}.
     *
     * If the given node itself is a resource collection, then only this single collection is returned. Otherwise the
     * method starts recursively searching all child nodes for resource collections.
     *
     * @param node The node to look up for resource collections.
     *
     * @return All available {@link com.adobe.granite.workflow.collection.ResourceCollection}s or an empty list if the
     *         node or any of its children is not a resource collection.
     */
    List<ResourceCollection> getCollectionsForNode(Node node);
}
