/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.model;

import com.adobe.granite.workflow.WorkflowException;

/**
 * <code>ValidationException</code> is used to indicate that a
 * {@link WorkflowModel} is not valid.
 */
public class ValidationException extends WorkflowException {
    /**
     * Generated serial version UID.
     */
    private static final long serialVersionUID = -8901352801743975909L;

    private WorkflowNode node;

    /**
     * Returns the {@link WorkflowNode} that is not valid or null if node could
     * not be determined.
     * 
     * @return The {@link WorkflowNode} that is not valid.
     */
    public WorkflowNode getNode() {
        return node;
    }

    /**
     * Constructs a new <code>WorkflowException</code> with the specified detail
     * message. The cause is not initialized, and may subsequently be
     * initialized by a call to {@link #initCause}.
     * 
     * @param message
     *            The detail message. The detail message is saved for later
     *            retrieval by the {@link #getMessage()} method.
     */
    public ValidationException(String message) {
        super(message);
    }

    /**
     * Constructs a new <code>WorkflowException</code> with the specified detail
     * message. The cause is not initialized, and may subsequently be
     * initialized by a call to {@link #initCause}.
     * 
     * @param message
     *            The detail message. The detail message is saved for later
     *            retrieval by the {@link #getMessage()} method.
     * @param node the workflow node
     */
    public ValidationException(String message, WorkflowNode node) {
        super(message);
        this.node = node;
    }

    /**
     * Constructs a new <code>WorkflowException</code> with the specified cause
     * and a detail message of <tt>(cause==null ? null : cause.toString())</tt>
     * (which typically contains the class and detail message of <tt>cause</tt>
     * ). This constructor is useful for <code>WorkflowException</code> that are
     * wrappers for other <code>{@link Throwable}</code>s.
     * 
     * @param cause
     *            The cause (which is saved for later retrieval by the
     *            {@link #getCause()} method). (A <tt>null</tt> value is
     *            permitted, and indicates that the cause is nonexistent or
     *            unknown.)
     */
    public ValidationException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new <code>WorkflowException</code> with the specified detail
     * message and cause.
     * 
     * @param message
     *            The detail message (which is saved for later retrieval by the
     *            {@link #getMessage()} method).
     * @param cause
     *            The cause (which is saved for later retrieval by the
     *            {@link #getCause()} method). (A <tt>null</tt> value is
     *            permitted, and indicates that the cause is nonexistent or
     *            unknown.)
     */
    public ValidationException(String message, Throwable cause) {
        super(message, cause);
    }

}
