/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.model;

/**
 * Interface for <code>{@link WorkflowModel}</code> filter implementation which
 * can be used to filter the result set when retrieving models.
 */
public interface WorkflowModelFilter {
    /**
     * Filter method which is called to check if a model should be filtered out
     * from the result set or not.
     * @param model the workflow model
     * 
     * @return Returns true if the model should be included, otherwise false.
     */
    boolean doInclude(WorkflowModel model);
}
