/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.payload;

import org.apache.sling.api.resource.ResourceResolver;

import aQute.bnd.annotation.ConsumerType;
import com.adobe.granite.workflow.exec.InboxItem;

/**
 * The builder responsible for popupating a {@link PayloadInfo} object for the payload being
 * represented in the {@link PayloadInfoBuilderContext}
 */
@ConsumerType
public interface PayloadInfoBuilder {
    /**
     * Build the PayloadInfo for the payload represented in the provided context.
     * @param context the {@link PayloadInfoBuilderContext}
     * @return the {@link PayloadInfo} containing information about the Payload
     */
    PayloadInfo getPayloadInfo(PayloadInfoBuilderContext context);
}
