/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.payload;

import aQute.bnd.annotation.ProviderType;
import com.adobe.granite.workflow.exec.InboxItem;

/**
 * The manager responsible for querying the different {@link PayloadInfoBuilder}'s to find one capable of providing
 * information about the payload represented by the {@link InboxItem} or located at the provided path.
  */
@ProviderType
public interface PayloadInfoBuilderManager {
    /**
     * Build the PayloadInfo for the payload represented by the InboxItem.
     * @param item the {@link InboxItem} representing the payload
     * @param initiatorHint a hint as to who initiated this request for payload info.  Null is a valid value.
     * @return the {@link PayloadInfo}
     */
    PayloadInfo getPayloadInfo(InboxItem item, String initiatorHint);

    /**
     * Build the PayloadInfo for the payload located at the specified path.
     * @param payloadPath the path to the payload
     * @param initiatorHint a hint as to who initiated this request for payload info.  Null is a valid value.
     * @return the {@link PayloadInfo}
     */
    PayloadInfo getPayloadInfo(String payloadPath, String initiatorHint);
}
