/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.xss;

/**
 * This service should be used to protect output against potential XSS attacks.
 * The protection is context based.
 *
 * @since 1.0
 * @deprecated Use {@link org.apache.sling.xss.XSSFilter} instead.
 */
@Deprecated
public interface XSSFilter {

    /**
     * Default context.
     */
    ProtectionContext DEFAULT_CONTEXT = ProtectionContext.HTML_HTML_CONTENT;

	/**
	 * Indicates whether or not a given source string contains XSS policy violations.
	 *
	 * @param context context to use for checking
	 * @param src source string
	 * @return true if the source is violation-free
	 * @throws NullPointerException if context is <code>null</code>
	 */
	boolean check(ProtectionContext context, String src);

	/**
	 * Indicates whether or not a given source string contains XSS policy violations.
	 *
	 * @param context context to use for checking
	 * @param src source string
	 * @param policy the name/path of the policy to use
	 * @return true if the source is violation-free
	 * @throws NullPointerException if context is <code>null</code>
	 */
	boolean check(ProtectionContext context, String src, String policy);

	/**
     * Prevents the given source string from containing XSS stuff.
     *
     * The default protection context is used for checking.
     *
     * @param src source string
     * @return string that does not contain XSS stuff
     */
    String filter(String src);

    /**
     * Protects the given source string from containing XSS stuff.
     *
     * @param context context to use for checking
     * @param src source string
     * @return string that does not contain XSS stuff
     * @throws NullPointerException if context is <code>null</code>
     */
    String filter(ProtectionContext context, String src);

    /**
     * Protects the given source string from containing XSS stuff.
     *
     * If the context is unknown or <code>null</code> the default context is used.
     *
     * @param context context to use for checking
     * @param src source string
     * @param policy the name/path of the policy to use
     * @return string that does not contain XSS stuff
     * @throws NullPointerException if context is <code>null</code>
     */
    String filter(ProtectionContext context, String src, String policy);
}
