/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.reef.siren;

import java.util.LinkedList;
import java.util.List;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * An {@code Action} is a behavior that is exposed from an {@link Entity}.
 */
public final class Action {

    private String name;

    private String[] clazz;

    private Method method;

    private String href;

    private String title;

    private String type;

    private List<Field> fields = new LinkedList<Field>();

    /**
     * Constructs a new Action.
     * 
     * @param name
     * @param href
     * @throws IllegalArgumentException
     */
    public Action(String name, String href) throws IllegalArgumentException {
        if (name == null || name.isEmpty() || href == null || href.isEmpty()) {
            throw new IllegalArgumentException("name and href can not be null or empty.");
        }
        this.name = name;
        this.href = href;
    }

    /**
     * Returns the name attribute.
     * 
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the name attribute.
     * 
     * @param name the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Returns the class attribute.
     * 
     * @return the clazz
     */
    public String[] getClazz() {
        return clazz;
    }

    /**
     * Sets the class attribute.
     * 
     * @param clazz the clazz to set
     */
    public void setClazz(String[] clazz) {
        this.clazz = clazz;
    }

    /**
     * Returns the method attribute.
     * 
     * @return the method
     */
    public Method getMethod() {
        return method;
    }

    /**
     * Sets the method attribute.
     * 
     * @param method the method to set
     */
    public void setMethod(Method method) {
        this.method = method;
    }

    /**
     * Returns the href attribute.
     * 
     * @return the href
     */
    public String getHref() {
        return href;
    }

    /**
     * Sets the href attribute.
     * 
     * @param href the href to set
     */
    public void setHref(String href) {
        this.href = href;
    }

    /**
     * Returns the title attribute.
     * 
     * @return the title
     */
    public String getTitle() {
        return title;
    }

    /**
     * Sets the title attribute.
     * 
     * @param title the title to set
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * Returns the type attribute.
     * 
     * @return the type
     */
    public String getType() {
        return type;
    }

    /**
     * Sets the type attribute.
     * 
     * @param type the type to set
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * Returns the fields.
     * 
     * @return the fields
     */
    public List<Field> getFields() {
        return fields;
    }

    /**
     * Sets the fields.
     * 
     * @param fields the fields to set
     */
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    /**
     * Adds a field
     * 
     * @param field the field to add
     */
    public void addField(Field field) {
        this.fields.add(field);
    }

    @Override
    public String toString() {
        try {
            JSONObject action = new JSONObject();
            action.put("name", name);
            action.put("href", href);
            if (clazz != null) {
                action.put("class", clazz);
            }
            if (method != null) {
                action.put("method", method);
            }
            if (type != null) {
                action.put("type", type);
            }
            if (title != null) {
                action.put("title", title);
            }
            if (!fields.isEmpty()) {
                List<JSONObject> fieldsJson = new LinkedList<JSONObject>();
                for(Field f : fields) {
                    fieldsJson.add(new JSONObject(f.toString()));
                }
                action.put("fields", fieldsJson);
            }
            return action.toString();
        }catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((href == null) ? 0 : href.hashCode());
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null) return false;
        if (getClass() != obj.getClass()) return false;
        Action other = (Action) obj;
        if (href == null) {
            if (other.href != null) return false;
        } else if (!href.equals(other.href)) return false;
        if (name == null) {
            if (other.name != null) return false;
        } else if (!name.equals(other.name)) return false;
        return true;
    }

    public enum Method {
        DELETE, 
        GET, 
        PATCH, 
        POST, 
        PUT;
    }

}
