/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.reef.siren;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * An {@code Entity} is a URI-addressable resource that has properties and
 * actions associated with it. It may contain sub-entities and navigational
 * links.
 */
public class Entity {

    protected String[] clazz;

    protected String[] rel;

    protected String href;

    protected String type;

    protected String title;

    protected Map<String, Object> properties = new HashMap<String,Object>();

    protected List<Entity> entities = new LinkedList<Entity>();

    protected List<Link> links = new LinkedList<Link>();

    protected List<Action> actions = new LinkedList<Action>();

    public Entity() {

    }

    /**
     * Returns the class property.
     * 
     * @return the class
     */
    public String[] getClazz() {
        return clazz;
    }

    /**
     * Sets the class property.
     * 
     * @param clazz the class to set
     */
    public void setClazz(String[] clazz) {
        this.clazz = clazz;
    }

    /**
     * Returns the rel property.
     * 
     * @return the rel
     */
    public String[] getRel() {
        return rel;
    }

    /**
     * Sets the rel property.
     * 
     * @param rel the rel to set
     */
    public void setRel(String[] rel) {
        this.rel = rel;
    }

    /**
     * Returns the hef property.
     * 
     * @return the href
     */
    public String getHref() {
        return href;
    }

    /**
     * Sets the href property.
     * 
     * @param href the href to set
     */
    public void setHref(String href) {
        this.href = href;
    }

    /**
     * Returns the type property.
     * 
     * @return the type
     */
    public String getType() {
        return type;
    }

    /**
     * Sets the type property.
     * 
     * @param href the type to set
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * Returns the title property.
     * 
     * @return the title
     */
    public String getTitle() {
        return title;
    }

    /**
     * Sets the title property.
     * 
     * @param title the title to set
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * Returns the properties.
     * 
     * @return the properties
     */
    public Map<String, Object> getProperties() {
        return properties;
    }

    /**
     * Sets the properties.
     * 
     * @param properties the properties to set
     */
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    /**
     * Returns the sub-entities.
     * 
     * @return the entities
     */
    public List<Entity> getEntities() {
        return entities;
    }

    /**
     * Sets the sub-entities.
     * 
     * @param entities the entities to set
     */
    public void setEntities(List<Entity> entities) {
        this.entities = entities;
    }

    /**
     * Returns the links.
     * 
     * @return the links
     */
    public List<Link> getLinks() {
        return links;
    }

    /**
     * Sets the links.
     * 
     * @param links the links to set
     */
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    /**
     * Returns the actions.
     * 
     * @return the actions
     */
    public List<Action> getActions() {
        return actions;
    }

    /**
     * Sets the actions.
     * 
     * @param actions the actions to set
     */
    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    @Override
    public String toString() {
        try {
            JSONObject entity = new JSONObject();
            if (clazz != null) {
                entity.put("class", clazz);
            }
            if (href != null) {
                entity.put("href", href);
            }
            if (rel != null) {
                entity.put("rel", rel);
            }
            if (title != null) {
                entity.put("title", title);
            }
            if (type != null) {
                entity.put("type", type);
            }
            if (!properties.isEmpty()) {
                entity.put("properties", properties);
            }
            if (!entities.isEmpty()) {
                List<JSONObject> entitiesJson = new LinkedList<JSONObject>();
                for (Entity e : entities) {
                    entitiesJson.add(new JSONObject(e.toString()));
                }
                entity.put("entities", entitiesJson);
            }
            if (!links.isEmpty()) {
                List<JSONObject> linksJson = new LinkedList<JSONObject>();
                for (Link l : links) {
                    linksJson.add(new JSONObject(l.toString()));
                }
                entity.put("links", linksJson);
            }
            if (!actions.isEmpty()) {
                List<JSONObject> actionsJson = new LinkedList<JSONObject>();
                for (Action a : actions) {
                    actionsJson.add(new JSONObject(a.toString()));
                }
                entity.put("actions", actionsJson);
            }
            return entity.toString();
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((href == null) ? 0 : href.hashCode());
        result = prime * result + Arrays.hashCode(rel);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null) return false;
        if (getClass() != obj.getClass()) return false;
        Entity other = (Entity) obj;
        if (href == null) {
            if (other.href != null) return false;
        } else if (!href.equals(other.href)) return false;
        if (!Arrays.equals(rel, other.rel)) return false;
        return true;
    }

}
