/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.reef.siren.builder;

/**
 * {@code Builder} is used to build instances of {@code <T>} from values
 * configured by the setters.
 * <p>
 * Builders can be reused, {@code clear()} resets all fields to their default values.
 * </p>
 * @param <T>
 */
public abstract class Builder<T> {

    /**
     * Builds the instance {@code T} after validating the values.
     * 
     * @return
     * @throws BuilderException if something goes wrong during build
     */
    public T build() throws BuilderException {
        T instance = doBuild();
        validate(instance);
        return instance;
    }

    /**
     * Resets all fields to their default values.
     */
    public abstract Builder<T> clear();

    /**
     * Builds the instance {@code T}.
     * 
     * @return
     * @throws BuilderException if something goes wrong during build
     */
    protected abstract T doBuild() throws BuilderException;

    /**
     * Validates an {@code instance}
     * 
     * @param instance
     * @throws BuilderValidationException if a value is not valid or missing
     */
    protected abstract void validate(T instance) throws BuilderValidationException;

}
