/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.reef.siren.builder;

import com.adobe.reef.siren.Field;
import com.adobe.reef.siren.Field.FieldType;

/**
 *{@code FieldBuilder} is a {@link Builder} implementation for {@link Field}.
 */
public class FieldBuilder extends Builder<Field> {

    private String name;

    private String title;

    private FieldType type = FieldType.TEXT;

    private String value;

    public FieldBuilder() {

    }

    public FieldBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public FieldBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public FieldBuilder setType(FieldType type) {
        this.type = type;
        return this;
    }

    public FieldBuilder setValue(String value) {
        this.value = value;
        return this;
    }

    public FieldBuilder clear() {
        name = null;
        title = null;
        type = null;
        value = null;
        return this;
    }

    protected Field doBuild() throws BuilderException {
        try {
            Field field = new Field(name);
            field.setTitle(title);
            field.setType(type);
            field.setValue(value);
            return field;
        } catch (IllegalArgumentException e) {
            throw new BuilderException(e.getMessage(), e);
        }
    }

    protected void validate(Field field) throws BuilderValidationException {
        if (field.getName() == null || field.getName().isEmpty()) {
            throw new BuilderValidationException("name cannot be null or empty.");
        }
    }
}
