/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2009, Adobe Systems Incorporated                             */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any. The           */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be covered by  */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/

package com.adobe.versioncue.nativecomm.host;

import com.adobe.versioncue.internal.nativecomm.host.Host;

/**
 * @author  <a href="mailto:tnaroska@adobe.com">tnaroska</a>
 * @version $Revision$
 * @since   CS5
 */
public class HostFactory
{
	/**
	 * Create an INCommHost instance using the specified delegate.
	 * 
	 * @param delegate - host delegate
	 * @return INCommHost instance
	 */
	public static INCommHost createHost(IHostDelegate delegate)
	{
//		 == PRE-CONDITION ==========================================================================
		if (delegate == null) throw new IllegalArgumentException();
//		 == PRE-CONDITION ==========================================================================

		return new Host(delegate);
	}
}
