/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2009, Adobe Systems Incorporated                             */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any. The           */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be covered by  */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/

package com.adobe.versioncue.nativecomm.host;

import java.io.InputStream;
import java.io.OutputStream;

import com.adobe.versioncue.nativecomm.NativeCommException;

/**
 * @author  <a href="mailto:tnaroska@adobe.com">tnaroska</a>
 * @version $Revision$
 * @since   CS5
 */
public interface INCommHost
{
	/**
	 * Add a new connection to this ncomm host instance.
	 *   
	 * @param in - connection InputStream
	 * @param out - connection OutputStream
	 * 
	 * @throws NativeCommException - on error
	 */
	void addConnection(InputStream in, OutputStream out) throws NativeCommException;

	/** @return number of currently connected clients */ 
	int activeClients();

	/** Terminate the host forcibly closing all active connections */
	void dispose();
}
