/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2001-2002, Adobe Systems Incorporated                        */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be covered by  */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/
package com.adobe.versioncue.nativecomm.msg;

/**
 * @author <a href="mailto:tnaroska@adobe.com">Timo Naroska</a>
 * @version $Revision: #1 $
 */
public final class NCBool extends NCType
{
	// ---------------------------------------------------------------------------- Public Constants

	/** Singleton TRUE instance */
	public static final NCBool TRUE = new NCBool(true);

	/** Singleton FALSE instance */
	public static final NCBool FALSE = new NCBool(false);

	// --------------------------------------------------------------------------- Private Variables

	/** Boolean value */
	private final boolean value;

	// ----------------------------------------------------------------------- Public Static Methods

	/**
	 * Returns a NCBool instance of the specified value.
	 * 
	 * @param value
	 *            boolean value to represent
	 * @return the NCBool instance
	 */
	public static NCBool getBoolean(boolean value)
	{
		return value ? TRUE : FALSE;
	}

	// ------------------------------------------------------------------------- Private Constructor

	/**
	 * Create a <code>NCBool</code> instance.
	 * 
	 * @param value
	 *            boolean value of the created instance
	 */
	private NCBool(boolean value)
	{
		this.value = value;
	}

	// ------------------------------------------------------------------------------ Public Methods

	/**
	 * Returns the boolean value of this object
	 * 
	 * @return boolean value of this object
	 */
	public boolean booleanValue()
	{
		return value;
	}

	/** @see Object#hashCode() */
	public int hashCode()
	{
		return System.identityHashCode(this);
	}

	/** @see Object#equals(java.lang.Object) */
	public boolean equals(Object other)
	{
		return other == this;
	}

	/** @see java.lang.Object#toString() */
	public String toString()
	{
		return this.value ? "NCBool <true>" : //$NON-NLS-1$
				"NCBool <false>"; //$NON-NLS-1$
	}

	/** @see NCType#getType() */
	public int getType()
	{
		return TYPE_BOOLEAN;
	}
}
