/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2001-2002, Adobe Systems Incorporated                        */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be covered by  */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/
package com.adobe.versioncue.nativecomm.msg;

/**
 * @author <a href="mailto:tnaroska@adobe.com">Timo Naroska</a>
 * @version $Revision: #1 $
 */
public abstract class NCNumber extends NCType
{
	// ----------------------------------------------------------------- Package Visible Constructor

	/** Ctor to prevent subclassing from outside this package */
	NCNumber()
	{
		// Empty
	}

	// --------------------------------------------------------------------- Public Abstract Methods

	/** @return integer value */
	public abstract int intValue();

	/** @return long value */
	public abstract long longValue();

	/** @return double value */
	public abstract double doubleValue();

	// ------------------------------------------------------------------------------ Public Methods

	@Override
	public abstract int hashCode();

	@Override
	public final boolean equals(Object other)
	{
		if (other != null && other instanceof NCNumber)
		{
			NCNumber otherNumber = (NCNumber) other;
			return doubleValue() == otherNumber.doubleValue();
		}
		return false;
	}
}
